/*
 * only Javascript, without jquery!
 */

(function () {
    if (typeof (BetGames) == 'undefined') BetGames = function () {};

    BetGames.bind = function (method, func) {
        if (typeof (BetGames[method]) == 'undefined') BetGames[method] = func;
        return BetGames[method]
    };

    BetGames.bind('i',0);

    BetGames.setts = {
        url_string: '/ext/client/index'
    };

    BetGames.bind('frame', function (_bt) {

        for (r = 0; r < _bt.length; r++) BetGames.setts[_bt[r][0]] = _bt[r][1];

        BetGames.i++;
        try {
            bFrame = document.createElement('<iframe frameborder=0 name="betgames_iframe_' + BetGames.i + '">');
        } catch (e) {
            bFrame = document.createElement('iframe');
            bFrame.name = 'betgames_iframe_' + BetGames.i;
            bFrame.setAttribute('frameborder', '0');
        }

        bFrame.id = 'betgames_iframe_' + BetGames.i;
        bFrame.setAttribute('allowFullScreen', '');
        bFrame.scrolling = "no";
        bFrame.src = BetGames.bind('make_location', function (sets) {
            sets = BetGames.setts;

            result = sets.server + sets.url_string;
            if (sets.partner) {
                result += '/' + sets.partner;
            } else {
                result += '/' + '-';
            }
            result += '/' + sets.token;

            result += '/' + sets.language;

            result += '/' + sets.timezone;

            if (sets.current_game) {
                result += '/' + sets.current_game;
            } else {
                result += '/0';
            }

            if (sets.is_mobile) {
                result += '/' + sets.is_mobile;
            } else {
                result += '/0';
            }
            if (sets.odds_format) {
                result += '/' + sets.odds_format;
            } else {
                result += '/default';
            }
            if (sets.home_url) {
                result += '?home_url=' + encodeURIComponent(sets.home_url);
            }

            return result;
        })(_bt)

        if (BetGames.width) {
            bFrame.width = BetGames.width;
        } else {
            // iOS mobile browsers ignore the iframe width attribute,
            // but they can recognize min-width css rule
            bFrame.width = '100%';
            bFrame.style.width = '1px';
            bFrame.style.minWidth = '100%';
        }

        if (BetGames.height) {
            bFrame.height = BetGames.height;
        } else {
            bFrame.height = '1300px';
        }

        if (document.getElementById('betgames_div_iframe') === null) {
            document.write('<div id="betgames_div_iframe"></div>');
        }

        document.getElementById('betgames_div_iframe').appendChild(bFrame);

        function getCoords(elem) {
            var box = elem.getBoundingClientRect();

            var body = document.body;
            var docEl = document.documentElement;

            var scrollTop = window.pageYOffset || docEl.scrollTop || body.scrollTop;
            var scrollLeft = window.pageXOffset || docEl.scrollLeft || body.scrollLeft;

            var clientTop = docEl.clientTop || body.clientTop || 0;
            var clientLeft = docEl.clientLeft || body.clientLeft || 0;

            var top  = box.top +  scrollTop - clientTop;
            var left = box.left + scrollLeft - clientLeft;

            return { top: Math.round(top), left: Math.round(left) };
        }

        var iframe = document.getElementById('betgames_div_iframe').firstChild;
        var iframeRect = getCoords(iframe);
        var anchorRect = null;

        function throttle(func, wait) {
            var timer = null;

            return function () {
                var _this = this;

                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                if (timer === null) {
                    timer = setTimeout(function () {
                        func.apply(_this, args);
                        timer = null;
                    }, wait);
                }
            };
        }

        function isIframeInViewport () {
            var top = iframeRect.top;
            var left = iframeRect.left;
            var width = iframe.offsetWidth;
            var height = iframe.offsetHeight;

            return (
                top < (window.pageYOffset + window.innerHeight) &&
                left < (window.pageXOffset + window.innerWidth) &&
                (top + height) > window.pageYOffset &&
                (left + width) > window.pageXOffset
            );
        }

        function isElementInViewport (elementRect) {
            var top = elementRect.top + iframeRect.top;
            var left = elementRect.left + iframeRect.left;

            return (
                (top + elementRect.height) > window.pageYOffset &&
                (left + elementRect.width) > window.pageXOffset
            );
        }

        function sendParentScrollData () {
            var top = window.pageYOffset ||
                document.documentElement.scrollTop ||
                document.body.scrollTop ||
                0;

            var cssTopValue = top - iframeRect.top;
            var dataString = JSON.stringify({
                cssTopValue: cssTopValue,
                isVisibleForParent: isElementInViewport({
                    top: anchorRect.top,
                    left: anchorRect.left,
                    width: anchorRect.width,
                    height: anchorRect.height,
                }),
                type: 'parentScrollData',
            });

            iframe.contentWindow.postMessage(dataString, '*');
        }

        window.addEventListener('scroll', throttle(function () {
            if (!isIframeInViewport()) return;

            if (!anchorRect) {
                iframe.contentWindow.postMessage(JSON.stringify({
                    type: 'getAnchorRect',
                }), '*');

                return;
            }

            sendParentScrollData();
        }, 200), false);

        window.addEventListener('message', function (event) {
            var data = event.data;

            if (typeof data !== 'string' || data.indexOf('anchorRect') === -1) return;

            anchorRect = JSON.parse(data);

            sendParentScrollData();
        }, false);
    });

    BetGames.bind('getPosition', function (obj) {
        var x = y = 0;
        if (obj.offsetParent) {
            x = obj.offsetLeft;
            y = obj.offsetTop;
            while (obj = obj.offsetParent) {
                x += obj.offsetLeft;
                y += obj.offsetTop
            }
        }
        return {
            left: x,
            top: y
        }
    });

    BetGames.bind('readMessage', function (msg) {
        res = {};
        var parts1 = msg.split('&');
        for (i = 0; i < parts1.length; i++) {
            part = parts1[i].split('=');
            res[part[0]] = part[1]
        }
        return res
    });

    BetGames.bind('getMessage', function (msg) {});

    BetGames.bind('getPosition', function (obj) {
        var x = y = 0;
        if (obj.offsetParent) {
            x = obj.offsetLeft;
            y = obj.offsetTop;
            while (obj = obj.offsetParent) {
                x += obj.offsetLeft;
                y += obj.offsetTop
            }
        }
        return {
            left: x,
            top: y
        }
    });

    BetGames.bind('resize', function (e) {
        if (!e.data) {
            _d = e;
            try {
                e = {
                    data: unescape(_d)
                }
            } catch (e) {}
        }
        if (BetGames.readMessage(e.data).height) {
            BetGames.getMessage(BetGames.readMessage(e.data));
            if (BetGames.readMessage(e.data).windowName) {
                document.getElementById(BetGames.readMessage(e.data).windowName).style.height = BetGames.readMessage(e.data).height;
                document.getElementById(BetGames.readMessage(e.data).windowName).height = BetGames.readMessage(e.data).height
            } else {
                for (r_i = 0; r_i < BetGames.l_iframes.length; r_i++) {
                    if (!BetGames.l_iframes[r_i].stopResize) {
                        document.getElementById('betgames_div_iframe').style.height = BetGames.readMessage(e.data).height;
                        document.getElementById('betgames_div_iframe').height = BetGames.readMessage(e.data).height
                    }
                }
            }
        } else if (BetGames.readMessage(e.data).toTop) {
            BetGames.getMessage(BetGames.readMessage(e.data));
            window.scroll(0, 0)
        } else if (BetGames.readMessage(e.data).scrollTo) {
            BetGames.getMessage(BetGames.readMessage(e.data));
            position = {
                left: 0,
                top: 0
            };
            if (BetGames.readMessage(e.data).windowName) {
                position = BetGames.getPosition(document.getElementById(BetGames.readMessage(e.data).windowName))
            }
            window.scroll(0, BetGames.readMessage(e.data).scrollTo - (position.top * (-1)))
        } else if (BetGames.readMessage(e.data).script_url) {
            BetGames.getMessage(BetGames.readMessage(e.data));
            var script = document.createElement('script');
            script.type = 'text/javascript';
            script.src = BetGames.readMessage(e.data).script_url;
            document.getElementsByTagName('head')[0].appendChild(script)
        } else if (BetGames.readMessage(e.data).action) {
            BetGames.getMessage(BetGames.readMessage(e.data))
        } else {
            try {
                dt = eval('r=' + e.data);
                request = (dt.postmessage) ? dt.postmessage : dt;
                BetGames.getMessage(request);
                if (request.type == 'new_resize') {
                    if (request.data && request.data.height) {
                        if (request.data.windowName) {
                            document.getElementById(request.data.windowName).style.height = request.data.height;
                            document.getElementById(request.data.windowName).height = request.data.height
                        } else {
                            for (r_i = 0; r_i < BetGames.l_iframes.length; r_i++) {
                                if (!BetGames.l_iframes[r_i].stopResize) {
                                    document.getElementById('betgames_div_iframe').style.height = request.data.height;
                                    document.getElementById('betgames_div_iframe').height = request.data.height
                                }
                            }
                        }
                    }
                }
                if (request.type == 'full_screen') {
                    if (request.data && request.data.screen_on==1) {
                        var div_iframe = document.getElementById('betgames_div_iframe');
                        div_iframe.style.top = '0';
                        div_iframe.style.left = '0';
                        div_iframe.style.right = '0';
                        div_iframe.style.bottom = '0';
                        div_iframe.style.zIndex = '99999';
                        div_iframe.style.position = "absolute";
                    } else {
                        var div_iframe = document.getElementById('betgames_div_iframe');
                        div_iframe.style.position = "static";
                        div_iframe.style.zIndex = '0';
                    }
                }
                if (request.type == 'top') {
                    window.scroll(0, 0)
                }
                if (request.type == 'iframeTop') {
                    if (request.data && request.data.topPlius) {
                        position = {
                            left: 0,
                            top: 0
                        };
                        if (request.data.windowName) {
                            position = BetGames.getPosition(document.getElementById(request.data.windowName))
                        }
                        window.scroll(0, request.data.topPlius + position.top);
                    }
                }
                if (request.data.script_url) {
                    var script = document.createElement('script');
                    script.type = 'text/javascript';
                    script.src = request.data.script_url;
                    document.getElementsByTagName('head')[0].appendChild(script)
                }
            } catch (er) {
                BetGames.getMessage(BetGames.readMessage(e.data))
            }
        }
    });

    (function () {
        if (typeof (window.postMessage) != 'undefined') {
            var eventMethod = window.addEventListener ? "addEventListener" : "attachEvent";
            var eventer = window[eventMethod];
            var messageEvent = eventMethod == "attachEvent" ? "onmessage" : "message";
            eventer(messageEvent, BetGames.resize, false)
        } else {
            BetGames.bind('hash_values', function () {
                var arr = window.location.hash.split("#");
                var hasValue = arr[1];
                if (typeof hasValue == "undefined") {
                    return ''
                }
                var hashLen = hasValue.indexOf("?");
                if (hashLen > 0) hasValue = hasValue.substring(0, hashLen);
                return hasValue
            });
            BetGames.last_hash = BetGames.hash_values();
            BetGames.bind('watch_hash', function () {
                var hash = BetGames.hash_values();
                if (hash !== BetGames.last_hash) {
                    if (hash.substring(0, 11) == 'BetGamesPM:') {
                        BetGames.resize({
                            data: hash.substring(11)
                        });
                        window.location.hash = ''
                    } else if (hash.substring(0, 16) == 'x-postmessage-id') {
                        BetGames.resize(hash.substring(49));
                        window.location.hash = ''
                    }
                    BetGames.last_hash = BetGames.hash_values()
                }
            });
            BetGames.bind('interval', setInterval(BetGames.watch_hash, 100));
            BetGames.bind('resize', function () {})
        }
    })();

    //disable all errors for affected site
    if (typeof (window.onerror) != 'undefined') window.onerror = function () {
        return true
    };
})();
