<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Sonuclandirma extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
        $this->load->model("Kontrol_basketbol");
        $this->load->model("Kontrol_basketbol_canli");
        $this->load->model("Kontrol_futbol_canli_anlik");
        $this->load->model("Kontrol_tenis");
        $this->load->model("Kontrol_tenis_canli");
    }

static function futbol_sonuclari(){

self::$db->join("bulten","bulten.mac_id=kupon_mac.mac_id and bulten.canli=kupon_mac.canli");
$futbol_sonuclar=self::$db->Where(array("kupon_mac.durum"=>0,"bulten.bittimi"=>1,"bulten.tur"=>1))->Select("kupon_mac.id,kupon_mac.mac_id, kupon_mac.oran_tur, kupon_mac.secim, bulten.tur, kupon_mac.canli, kupon_mac.Id AS kupon_mac_id,bulten.iy, bulten.ft, bulten.ums, bulten.pms, bulten.ms, bulten.ilk_gol, bulten.son_gol,bulten.s1,bulten.s2,bulten.s3,bulten.s4,bulten.s5,bulten.s6,bulten.s7,bulten.s8,bulten.s9,bulten.s10,bulten.s11")->group_by("kupon_mac.id")->get('kupon_mac')->result();
//print_r($futbol_sonuclar);

foreach ($futbol_sonuclar as $maclar) {

$canlimi_mac="";
if($maclar->canli==0){
$sonuc=Kontrol_futbol::kontrolfutbol($maclar->mac_id,$maclar->iy,$maclar->ft,$maclar->oran_tur,$maclar->secim,$maclar->ilk_gol,$maclar->son_gol);
$canlimi_mac="Normal Maç";
}elseif($maclar->canli==1){
$canlimi_mac="Canlı Maç";
$sonuc=Kontrol_futbol_canli::kontrolfutbol($maclar->mac_id,$maclar->iy,$maclar->ft,$maclar->oran_tur,$maclar->secim,$maclar->ilk_gol,$maclar->son_gol,$maclar->s1,$maclar->s2,$maclar->s3,$maclar->s4,$maclar->s5,$maclar->s6,$maclar->s7,$maclar->s8,$maclar->s9,$maclar->s10,$maclar->s11);

} 

$data=array("durum"=>$sonuc,
      "iy"=>$maclar->iy,
      "ms"=>$maclar->ms);
$where=array("Id"=>$maclar->kupon_mac_id);
self::$db->set($data)->where($where)->update('kupon_mac');


echo "Futbol :<b>".$canlimi_mac." :</b> ".$maclar->mac_id." - ".$maclar->kupon_mac_id." - ".$maclar->oran_tur. " - İy: ".$maclar->iy." - Ft: ".$maclar->ft . " - ".$maclar->secim. " - " .$sonuc; 
echo "<br>";

//maçların sonu
}
return false;
}
static function futbol_sonuclari_anlik(){

self::$db->join("bulten","bulten.mac_id=kupon_mac.mac_id and bulten.canli=kupon_mac.canli");
$futbol_sonuclar=self::$db->Where(array("kupon_mac.durum"=>0,"bulten.tur"=>1))->Select("kupon_mac.id,kupon_mac.mac_id, kupon_mac.oran_tur, kupon_mac.secim, bulten.tur, kupon_mac.canli, kupon_mac.Id AS kupon_mac_id,bulten.iy, bulten.ft, bulten.ums, bulten.pms, bulten.ms, bulten.ilk_gol, bulten.son_gol,bulten.s1,bulten.s2,bulten.s3,bulten.s4,bulten.s5,bulten.s6,bulten.s7,bulten.s8,bulten.s9,bulten.s10,bulten.s11,bulten.iybittimi")->group_by("kupon_mac.id")->get('kupon_mac')->result();

//print_r($futbol_sonuclar);

foreach ($futbol_sonuclar as $maclar) {
if($maclar->canli==1){
$canlimi_mac="Canlı Maç";
$sonuc=Kontrol_futbol_canli_anlik::kontrolfutbol_anlik($maclar->iybittimi,$maclar->mac_id,$maclar->iy,$maclar->ms,$maclar->oran_tur,$maclar->secim,$maclar->ilk_gol,$maclar->son_gol,$maclar->s1,$maclar->s2,$maclar->s3,$maclar->s4,$maclar->s5,$maclar->s6,$maclar->s7,$maclar->s8,$maclar->s9,$maclar->s10,$maclar->s11);
if($sonuc==""){
    $sonuc=0;
}else{
    $sonuc=$sonuc;
}
$data=array("durum"=>$sonuc,
      "iy"=>$maclar->iy,
      "ms"=>$maclar->ms);
$where=array("Id"=>$maclar->kupon_mac_id);
self::$db->set($data)->where($where)->update('kupon_mac');

echo "Futbol<b> Anlık ".$canlimi_mac." :</b> ".$maclar->mac_id." - ".$maclar->kupon_mac_id." - ".$maclar->oran_tur. " - İy: ".$maclar->iy." - Ft: ".$maclar->ft . " - ".$maclar->secim. " - " .$sonuc; 
echo "<br>";
}
//maçların sonu
}
return false;
}
static function basketbol_sonuclari(){

self::$db->join("bulten","bulten.mac_id=kupon_mac.mac_id and bulten.canli=kupon_mac.canli");
$futbol_sonuclar=self::$db->Where(array("kupon_mac.durum"=>0,"bulten.bittimi"=>1,"bulten.tur"=>2))->Select("kupon_mac.id,kupon_mac.mac_id, kupon_mac.oran_tur, kupon_mac.secim, bulten.tur, kupon_mac.canli, kupon_mac.Id AS kupon_mac_id, bulten.ft, bulten.ms, bulten.p1, bulten.p2, bulten.p3, bulten.p4")->group_by("kupon_mac.id")->get('kupon_mac')->result();
//print_r($futbol_sonuclar);

foreach ($futbol_sonuclar as $maclar) {

$canlimi_mac="";
if($maclar->canli==0){
$sonuc=Kontrol_basketbol::kontrolbasketbol($maclar->mac_id,$maclar->ft,$maclar->ms,$maclar->p1,$maclar->p2,$maclar->p3,$maclar->p4,$maclar->oran_tur,$maclar->secim);
$canlimi_mac="Normal Maç";
}elseif($maclar->canli==1){
$canlimi_mac="Canlı Maç";
$sonuc=0;
$sonuc=Kontrol_basketbol_canli::kontrolbasketbol($maclar->mac_id,$maclar->ft,$maclar->ms,$maclar->p1,$maclar->p2,$maclar->p3,$maclar->p4,$maclar->oran_tur,$maclar->secim);

} 

$data=array("durum"=>$sonuc,
      "iy"=>$maclar->ft,
      "ms"=>$maclar->ms);
$where=array("Id"=>$maclar->kupon_mac_id);
self::$db->set($data)->where($where)->update('kupon_mac');


echo "Basket :<b>".$canlimi_mac." :</b> ".$maclar->mac_id." - ".$maclar->kupon_mac_id." - ".$maclar->oran_tur. " - Ft: ".$maclar->ft." - Ms: ".$maclar->ms . " - ".$maclar->secim. " - " .$sonuc; 
echo "<br>";

//maçların sonu
}
return false;
}
static function tenis_sonuclari(){

self::$db->join("bulten","bulten.mac_id=kupon_mac.mac_id and bulten.canli=kupon_mac.canli");
$futbol_sonuclar=self::$db->Where(array("kupon_mac.durum"=>0,"bulten.bittimi"=>1,"bulten.tur"=>5))->Select("kupon_mac.id,kupon_mac.mac_id, kupon_mac.oran_tur, kupon_mac.secim, bulten.tur, kupon_mac.canli, kupon_mac.Id AS kupon_mac_id, bulten.ft, bulten.ms, bulten.p1, bulten.p2, bulten.p3, bulten.p4")->group_by("kupon_mac.id")->get('kupon_mac')->result();

//print_r($futbol_sonuclar);

foreach ($futbol_sonuclar as $maclar) {

$canlimi_mac="";
if($maclar->canli==0){
$sonuc=Kontrol_tenis::kontrol($maclar->mac_id,$maclar->ft,$maclar->ms,$maclar->p1,$maclar->p2,$maclar->p3,$maclar->p4,$maclar->oran_tur,$maclar->secim);
$canlimi_mac="Normal Maç";
}elseif($maclar->canli==1){
$canlimi_mac="Canlı Maç";
$sonuc=0;
$sonuc=Kontrol_tenis_canli::kontrol($maclar->mac_id,$maclar->ft,$maclar->ms,$maclar->p1,$maclar->p2,$maclar->p3,$maclar->p4,$maclar->oran_tur,$maclar->secim);

} 

$data=array("durum"=>$sonuc,
      "iy"=>$maclar->ft,
      "ms"=>$maclar->ms);
$where=array("Id"=>$maclar->kupon_mac_id);
self::$db->set($data)->where($where)->update('kupon_mac');


echo "Tenis :<b>".$canlimi_mac." :</b> ".$maclar->mac_id." - ".$maclar->kupon_mac_id." - ".$maclar->oran_tur. " - Ft: ".$maclar->ft." - Ms: ".$maclar->ms . " - ".$maclar->secim. " - " .$sonuc; 
echo "<br>";

//maçların sonu
}
return false;
}

}