<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Coupons extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }


    static function ozet_toplam_kupon($kullanici = NULL , $durum = NULL , $tarih1, $tarih2)
    {
        $ci = &get_instance();
$where["date(tarih)>="]=date("Y-m-d",strtotime($tarih1));
$where["date(tarih)<="]=date("Y-m-d",strtotime($tarih2));

if($kullanici!=NULL && strlen($kullanici)){
$where["user_id"]=$kullanici;
}

if($durum!=NULL && strlen($durum)){
  if($durum==-1){
$where["durum"]=0;
  }else{
$where["durum"]=$durum;
}
}

//print_r($where);
return self::$db->where($where)->Select("Count(Id) AS toplam, SUM(miktar) AS yatan, SUM(oran*miktar) AS olasi_kazanc")->get('kupon')->row();
   }

   static function kupon_listesi($durum,$kuponid,$tarih1,$tarih2,$limit)
    {
        $ci = &get_instance();
$where["date(kupon.tarih)>="]=date("Y-m-d",strtotime($tarih1));
$where["date(kupon.tarih)<="]=date("Y-m-d",strtotime($tarih2));

if($kuponid!=NULL && strlen($kuponid)){
$where["kupon.Id"]=$kuponid;
}

if($durum!=NULL && strlen($durum)){
$where["kupon.durum"]=$durum;
}

self::$db->join("users","users.id=kupon.user_id");
self::$db->join("kupon_mac","kupon_mac.kupon_id=kupon.ID and kupon_mac.durum>0","left");
//return self::$db->where($where)->group_by("kupon.Id")->order_by("Id","DESC")->Select("kupon.Id,kupon.tarih,kupon.toplam,kupon.miktar,kupon.oran,users.username, count(kupon_mac.Id) AS biten")->get('kupon',$limit,$start)->result();
return self::$db->where($where)->group_by("kupon.Id")->order_by("Id","DESC")->Select("kupon.Id,kupon.tarih,kupon.toplam,kupon.miktar,kupon.oran,kupon.durum,users.username,count(kupon_mac.Id) AS biten")->get('kupon',$limit)->result();
   }


static function kupon_detay($kupon_id){
self::$db->join("users","users.id=kupon.user_id");
self::$db->join("kupon_mac","kupon_mac.kupon_id=kupon.ID and kupon_mac.durum>0","left");
return self::$db->where(array("kupon.id"=>$kupon_id))->group_by("kupon.Id")->order_by("Id","DESC")->Select("kupon.*,users.username, count(kupon_mac.Id) AS biten")->get('kupon')->row();
}

static function kupon_maclar($kupon_id){
return self::$db->where(array("kupon_mac.kupon_id"=>$kupon_id))->Select("*")->get('kupon_mac')->result();
}

static function mac_durum($durum_id){
return self::$db->where(array("durum_id"=>$durum_id))->Select("durum")->get('mac_durumlari')->row();	
}




}

/* End of file model.php */
