<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Casinoslot extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

    function __construct()
    {
        parent::__construct();
        $this->load->helper("url");
        $this->load->database();
        $this->load->library("session");
        
       


    }
    


	public function index()
	{  

function checkHash( &$Params, $IP, $Request, $ApiKey, $ApiPw )
{
    $md5 = generateHash($Params, $IP, $Request, $ApiKey, $ApiPw);
    return $Params['Hash'] === $md5;
}

function generateHash( $Params, $IP, $Request, $ApiKey, $ApiPw )
{
    $Request = trim($Request, '/');
    switch ($Request)
    {
        case 'User/Add':
            $hash_base = $Request . '/'.
                    $IP.'/'.
                    $Params['TID'].'/'.
                    $ApiKey.'/'.
                    $Params['Login'].'/'.
                    $Params['Password'].'/'.
                    $Params['Currency'].'/'.
                    $ApiPw;
                    //$Params['Password'];
            break;
        case 'Balance/Get':
            $hash_base = $Request . '/'.
                    $IP.'/'.
                    $Params['TID'].'/'.
                    $ApiKey.'/'.
                    $Params['System'].'/'.
                    $Params['Login'].'/'.
                    $ApiPw;
            break;
        case 'User/DirectAuth':
        case 'User/AuthHTML':
            $hash_base = $Request . '/'.
                    $IP.'/'.
                    $Params['TID'].'/'.
                    $ApiKey.'/'.
                    $Params['Login'].'/'.
                    $Params['Password'].'/'.
                    $Params['System'].'/'.
                    $ApiPw;
            break;
        case 'Stats/BetsSummary':
        case 'Stats/Bets':
        case 'Stats/Detailed':
            $hash_base = $Request . '/'.
                    $IP.'/'.
                    $Params['TID'].'/'.
                    $ApiKey.'/'.
                    $Params['Date'].'/'.
                    $ApiPw;
            break;
        case 'User/GetGameHistoryUrl':
        case 'User/KillAuth':
            $hash_base = $Request . '/'.
                    $IP.'/'.
                    $Params['TID'].'/'.
                    $ApiKey.'/'.
                    $Params['Login'].'/'.
                    $ApiPw;
            break;
        case 'Game/List':
        case 'Game/FullList':
            $hash_base = $Request . '/'.
                    $IP.'/'.
                    $Params['TID'].'/'.
                    $ApiKey.'/'.
                    $ApiPw;
            break;
        case 'Balance/Set':
            $hash_base = $Request . '/'.
                    $IP.'/'.
                    $Params['TID'].'/'.
                    $ApiKey.'/'.
                    $Params['System'].'/'.
                    $Params['Amount'].'/'.
                    $Params['Login'].'/'.
                    $Params['Currency'].'/'.
                    $ApiPw;
            break;
    }

    $hash = md5($hash_base);
    return $hash;
}

#
#   Taken from the PHP documentation website.
#
#   Kristof_Polleunis at yahoo dot com
#
#   A guid function that works in all php versions:
#   MEM 3/30/2015 : Modified the function to allow someone
#       to specify whether or not they want the curly
#       braces on the GUID.
#
function guid( $opt = true ){       //  Set to true/false as your default way to do this.

    if( function_exists('com_create_guid') ){
        if( $opt ){ return com_create_guid(); }
            else { return trim( com_create_guid(), '{}' ); }
        }
        else {
            mt_srand( (double)microtime() * 10000 );    // optional for php 4.2.0 and up.
            $charid = strtoupper( md5(uniqid(rand(), true)) );
            $hyphen = chr( 45 );    // "-"
            $left_curly = $opt ? chr(123) : "";     //  "{"
            $right_curly = $opt ? chr(125) : "";    //  "}"
            $uuid = $left_curly
                . substr( $charid, 0, 8 ) . $hyphen
                . substr( $charid, 8, 4 ) . $hyphen
                . substr( $charid, 12, 4 ) . $hyphen
                . substr( $charid, 16, 4 ) . $hyphen
                . substr( $charid, 20, 12 )
                . $right_curly;
            return $uuid;
            }
}



function apiRequest($Url) {
    //curl request
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $Url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        ]);

    $result = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);

    return ['Result' => $result, 'Info' => $info];
}

function getUserIP(){
    if ( isset($_SERVER) && isset($_SERVER['REMOTE_ADDR']) && ($_SERVER['REMOTE_ADDR']!='127.0.0.1') ) {
        $ip = $_SERVER['REMOTE_ADDR'];
    } else {
        //Fallback to get external IP, in case development server is on the same machine
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => 'http://api.ipify.org/',
            CURLOPT_RETURNTRANSFER => true,
            ]);

        $result = curl_exec($ch);
        $info = curl_getinfo($ch);

        curl_close($ch);
        $ip = '';

        if ( $info['http_code']=='200' ) {
            $ip = $result;
        }
    }

    return $ip;
}

function apiCall($Request, $Params, $Api) {
    if ( !isset($Api['Url']) && isset($Api['BaseUrl']) ) {
        $Api['Url'] = $Api['BaseUrl'];
    }

    $Params['Hash'] = generateHash($Params, '0.0.0.0', $Request, $Api['Key'], $Api['Password']);

    $UrlParts = [$Api['Url'], $Api['Key'], $Request, '?&' . http_build_query($Params)];
    $Url = implode('/', $UrlParts);
    return apiRequest($Url);
}

function generateUrl($BaseUrl, $Key, $Pass, $Request, $Params) {
    $UrlParts = [
        $BaseUrl,
        $Key, 
        $Request, 
        '?&' . http_build_query($Params)
        ];

    $Url = implode('/', $UrlParts);
    return $Url;
}

function processResponse($Request, $Response) {
    $responseFailed = false;
    switch ($Request) {
        case 'Game/List': 
                $gameList = json_decode($Response['Result'], true);

                if ( $Response['Info']['http_code'] == '200' && ( $gameList !== false ) ) {
                    var_dump($gameList);
                }
                else {
                    $responseFailed = true;
                }
            break;
        default:
            $SplitResult = explode(',', $Response['Result'], 2);

            $ResponseCode = $SplitResult[0];
            $ResponseData = '';

            if ( isset($SplitResult[1]) ) {
                $ResponseData = $SplitResult[1];
            }

            if ( ($Response['Info']['http_code'] != '200') || ($ResponseCode != 1)) {
                $responseFailed = true;
                break;
            }

            switch ($Request) {
                case 'User/Add':
                case 'User/Update':
                    echo "User created or updated\n";
                    break;

                case 'User/DirectAuth':
                    echo 'Game URL: ' . $ResponseData . "\n";
                    break;

                case 'User/AuthHTML':
                    echo 'Game HTML fragment: ' . $ResponseData . "\n";
                    break;

                case 'Balance/Get':
                    echo 'Player balance: ' . $ResponseData . "\n";
                    break;

                case 'Balance/Set':
                    echo 'Player balance after transaction: ' . $ResponseData . "\n";
                    break;
            }
            break;
    }

    if ( $responseFailed === true ) {
        echo "Something gone wrong: HTTP response code: " . $Response['Info']['http_code'] . "\n";
        echo "Response body: " . $Response['Result'];
    }
    echo "\n";
}

	 /* */
		$Credentials = [
		    'eveb_test' => [
		        'BaseUrl' => 'https://apitest.fundist.org//System/Api',
		        'Key' => '1fd8f3809fb9bab8f8a84fb1d7cecae8',
		        'Password' => '9278649935978442',
		        ],
		];
	    $Api = $Credentials['eveb_test'];
	    $Params = ['TID' => guid($curly=false), ];
	    $Response = apiCall($Request='Game/List', $Params, $Api);
        $gameList = json_decode($Response['Result'], true);
       

       $sonuc= $Response['Result'];
       $data['katalog']=json_decode($sonuc);
       $data['base'] ='https://fundist.org/';

     

	    
	 

         $this->load->view('casino/slotlar',isset($data) ? $data : NULL);
	}



}
