<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Genel extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }

static function ayarlar(){
return self::$db->Select("*")->get('ayarlar')->row();    
}

static function slider(){
return self::$db->Select("*")->get('slayt')->result();    
}

    // Get logged in user ID
    static function todayFixtures()
    {
        $ci = &get_instance();
       return self::$db->Where(array("bittimi"=>0,"date(tarih)"=>date("Y-m-d"),"tarih>"=>date("Y-m-d H:i:s"),"aktif"=>1,"canli"=>0))->Select("tur,tur_isim,count(Id) AS toplam")->Group_by("tur")->get('bulten')->result();
    }

 static function one_cikan_ligler(){

        self::$db->join('ligler','ligler.lig_id = bulten.lig_id');
       return self::$db->Where(array("ligler.one_cikan"=>1,"bulten.bittimi"=>0,"bulten.tarih>"=>date("Y-m-d H:i:s"),"bulten.canli"=>0))->Select("bulten.lig_id,bulten.lig, count(bulten.Id) AS toplam, ligler.sporttype,ligler.country")->Group_by("tur")->get('bulten')->result();

 }
    static function yaklasan_maclar_kategori()
    {


$son_tarih=date('Y-m-d H:i:s', mktime(date('H')+12, date('i'), date('s'), date('m'), date('d'), date('Y')));
self::$db->join("mac_turleri","mac_turleri.tur_id=bulten.tur");
return self::$db->Where(array("bulten.bittimi"=>0,"bulten.tarih>"=>date("Y-m-d H:i:s"),"bulten.tarih<"=>$son_tarih))->Select("bulten.tur,bulten.tur_isim,bulten.OddsType,mac_turleri.css_id")->Group_by("tur")->get('bulten',9)->result();


    }

    static function yaklasan_maclar($tur_id)
    {


$son_tarih=date('Y-m-d H:i:s', mktime(date('H')+12, date('i'), date('s'), date('m'), date('d'), date('Y')));

$maclar= self::$db->Where(array("tur"=>$tur_id,"bittimi"=>0,"tarih>"=>date("Y-m-d H:i:s"),"tarih<"=>$son_tarih,"canli"=>0))->Select("Id, tur, tur_isim, ulke_id, ulke, lig_id, lig, mac_id, ev_sahibi, misafir, tarih, mbs, Odds1, Odds0, Odds2, Odds1Old, Odds0Old, Odds2Old, OddsType1, OddsType0, OddsType2, ColumnCount, oran_sayi,OddsType,Odds1ID,Odds0ID,Odds2ID")->Group_by("mac_id")->order_by("tarih","ASC")->get('bulten',25)->result();



$maclar_array=array();
$maclar_id=array();

 foreach ($maclar as $maclar) {
    $mac_id=$maclar->mac_id;
      
    /*  
      $altust=self::$db->Where(array("OddsType"=>"2.5 Gol Alt / Üst","MatchID"=>$mac_id,"SportID"=>"1"))->Select("*")->get('bulten_oranlar')->result();
      
       $golvaryok=self::$db->Where(array("OddsType"=>"İki Takım da Gol Atar","MatchID"=>$mac_id,"SportID"=>"1"))->Select("*")->get('bulten_oranlar')->result();
 */
       
$canlikontrolwhere["bulten.canli"]=1;
$canlikontrolwhere["bulten.mac_id"]=$maclar->mac_id;
$canlikontrol=self::$db->Where($canlikontrolwhere)->Select("canli")->get('bulten')->num_rows();  
$maclar_array[]=array("Id"=>$maclar->Id,
                    "tur"=>$maclar->tur,
                    "tur_isim"=>$maclar->tur_isim,
                    "ulke_id"=>$maclar->ulke_id,
                    "ulke"=>$maclar->ulke,
                    "canli"=>$canlikontrol,
                    "lig"=>$maclar->lig,
                    "mac_id"=>$maclar->mac_id,
                    "ev_sahibi"=>$maclar->ev_sahibi,
                    "misafir"=>$maclar->misafir,
                    "tarih"=>$maclar->tarih,
                    "mbs"=>$maclar->mbs,
                    "Odds1"=>$maclar->Odds1,
                    "Odds0"=>$maclar->Odds0,
                    "Odds2"=>$maclar->Odds2,
                    "Odds1Old"=>$maclar->Odds1Old,
                    "Odds0Old"=>$maclar->Odds0Old,
                    "Odds2Old"=>$maclar->Odds2Old,
                    "OddsType"=>$maclar->OddsType,
                    "OddsType1"=>$maclar->OddsType1,
                    "OddsType0"=>$maclar->OddsType0,
                    "Odds1ID"=>$maclar->Odds1ID,
                    "Odds0ID"=>$maclar->Odds0ID,
                    "Odds2ID"=>$maclar->Odds2ID,
                    "OddsType2"=>$maclar->OddsType2,
                    "ColumnCount"=>$maclar->ColumnCount,
                    "altust"=>$altust,
                    "golvaryok"=>$golvaryok,
                    "oran_sayi"=>$maclar->oran_sayi);


 }
 
 
return $maclar_array;


    }



static function leftsportmenu(){
$zaman = date("Y-m-d H:i:s");
//$zaman= date("Y-m-d H:i:s", strtotime($date . '-5 minutes'));

$sonucum=self::$db->Where("sol_menu_yenilenme_saati>",$zaman)->Select("sol_menu_json")->get("ayarlar")->row();


  $sonuc=json_decode($sonucum->sol_menu_json,true);

return $sonuc;
}



static function mac_listesi($tur = NULL, $ulke_id = NULL , $lig_id = NULL, $tarih = NULL){


$sorgu_tur["bulten.bittimi"]=0;
if($tarih!=NULL){
$sorgu_tur["date(bulten.tarih)"]=date("Y-m-d",strtotime($tarih));
$sorgu_ulke["date(bulten.tarih)"]=date("Y-m-d",strtotime($tarih));
$sorgu_lig["date(bulten.tarih)"]=date("Y-m-d",strtotime($tarih));
$sorgu_maclar["date(bulten.tarih)"]=date("Y-m-d",strtotime($tarih));
}

if($ulke_id=="" && $lig_id=="" && $tarih==""){
$tarih=date('Y-m-d H:i:s', mktime(date('H'), date('i'), date('s'), date('m'), date('d')+4, date('Y')));  
$sorgu_tur["date(bulten.tarih)<"]=date("Y-m-d",strtotime($tarih));
$sorgu_ulke["date(bulten.tarih)<"]=date("Y-m-d",strtotime($tarih));
$sorgu_lig["date(bulten.tarih)<"]=date("Y-m-d",strtotime($tarih));
$sorgu_maclar["date(bulten.tarih)<"]=date("Y-m-d",strtotime($tarih));
}

$sorgu_tur["bulten.aktif"]=1;
$sorgu_tur["bulten.tarih>"]=date("Y-m-d H:i:s");
$sorgu_tur["bulten.canli"]=0;
if($tur!=NULL){
$sorgu_tur["bulten.tur"]=$tur;  
}

self::$db->join('mac_turleri','mac_turleri.tur_id = bulten.tur');
$turler=self::$db->Where($sorgu_tur)->Select("bulten.tur,bulten.tur_isim, count(bulten.Id) AS toplam,mac_turleri.css_id,bulten.OddsType")->Group_by("tur")->get('bulten')->result();

//print_r($turler);

$sport_menu=array();


foreach ($turler as $turler) {

$ulkeler_array=array();

$sorgu_ulke["bulten.bittimi"]=0;
if($tarih!=NULL){

}


$sorgu_ulke["bulten.aktif"]=1;
$sorgu_ulke["bulten.tarih>"]=date("Y-m-d H:i:s");
$sorgu_ulke["bulten.canli"]=0;
$sorgu_ulke["bulten.tur"]=$turler->tur;
$sorgu_ulke["ulkeler.sporttype"]=$turler->tur;
if($ulke_id!=NULL){
$sorgu_ulke["bulten.ulke_id"]=$ulke_id;  
}

self::$db->join('ulkeler','ulkeler.country_id = bulten.ulke_id');
$ulkeler=self::$db->Where($sorgu_ulke)->Select("bulten.ulke_id,bulten.ulke, count(bulten.Id) AS toplam,ulkeler.css_id")->Group_by("bulten.ulke_id")->order_by("ulkeler.siralama","ASC")->order_by("ulkeler.country_id","ASC")->get('bulten')->result();

foreach ($ulkeler as $ulkeler) {

$ligler_array=array();

if($lig_id!=NULL){
$sorgu_lig["bulten.lig_id"]=$lig_id;  
}

$sorgu_lig["bulten.bittimi"]=0;

$sorgu_lig["bulten.aktif"]=1;
$sorgu_lig["bulten.tarih>"]=date("Y-m-d H:i:s");
$sorgu_lig["bulten.canli"]=0;
$sorgu_lig["bulten.tur"]=$turler->tur;
$sorgu_lig["bulten.ulke_id"]=$ulkeler->ulke_id;
    
$ligler=self::$db->Where($sorgu_lig)->Select("lig,lig_id, count(bulten.Id) AS toplam")->Group_by("lig_id")->get('bulten')->result();    

foreach ($ligler as $ligler) {

$maclar_array=array();



$sorgu_maclar["bulten.bittimi"]=0;
$sorgu_maclar["bulten.aktif"]=1;
$sorgu_maclar["bulten.tarih>"]=date("Y-m-d H:i:s");
$sorgu_maclar["bulten.canli"]=0;
$sorgu_maclar["bulten.tur"]=$turler->tur;
$sorgu_maclar["bulten.ulke_id"]=$ulkeler->ulke_id;
$sorgu_maclar["bulten.lig_id"]=$ligler->lig_id;



$maclar=self::$db->Where($sorgu_maclar)->Select("Id, tur, tur_isim, ulke_id, ulke, lig_id, lig, mac_id, ev_sahibi, misafir, tarih, mbs, Odds1, Odds0, Odds2, Odds1Old, Odds0Old, Odds2Old, OddsType1, OddsType0, OddsType2, ColumnCount, oran_sayi,OddsType,OddsType,Odds1ID,Odds0ID,Odds2ID")->get('bulten')->result();    

//print_r($maclar);
  
 foreach ($maclar as $maclar) {
$canlikontrolwhere["bulten.canli"]=1;
$canlikontrolwhere["bulten.mac_id"]=$maclar->mac_id;
$canlikontrol=self::$db->Where($canlikontrolwhere)->Select("canli")->get('bulten')->num_rows();  
$maclar_array[]=array("Id"=>$maclar->Id,
                    "tur"=>$maclar->tur,
                    "tur_isim"=>$maclar->tur_isim,
                    "ulke_id"=>$maclar->ulke_id,
                    "ulke"=>$maclar->ulke,
                    "canli"=>$canlikontrol,
                    "lig_id"=>$maclar->lig_id,
                    "lig"=>$maclar->lig,
                    "mac_id"=>$maclar->mac_id,
                    "ev_sahibi"=>$maclar->ev_sahibi,
                    "misafir"=>$maclar->misafir,
                    "tarih"=>$maclar->tarih,
                    "mbs"=>$maclar->mbs,
                    "Odds1"=>$maclar->Odds1,
                    "Odds0"=>$maclar->Odds0,
                    "Odds2"=>$maclar->Odds2,
                    "Odds1Old"=>$maclar->Odds1Old,
                    "Odds0Old"=>$maclar->Odds0Old,
                    "Odds2Old"=>$maclar->Odds2Old,
                    "OddsType"=>$maclar->OddsType,
                    "OddsType1"=>$maclar->OddsType1,
                    "OddsType0"=>$maclar->OddsType0,
                    "Odds1ID"=>$maclar->Odds1ID,
                    "Odds0ID"=>$maclar->Odds0ID,
                    "Odds2ID"=>$maclar->Odds2ID,
                    "OddsType2"=>$maclar->OddsType2,
                    "ColumnCount"=>$maclar->ColumnCount,
                    "oran_sayi"=>$maclar->oran_sayi);


 }
$ligler_array[]=array("lig_id"=>$ligler->lig_id,
                    "lig"=>$ligler->lig,
                    "toplam"=>$ligler->toplam,
                    "maclar"=>$maclar_array);

}
$ulkeler_array[]=array("ulke_id"=>$ulkeler->ulke_id,
                       "ulke"=>$ulkeler->ulke,
                       "css_id"=>$ulkeler->css_id,
                       "toplam"=>$ulkeler->toplam,
                       "ligler"=>$ligler_array);





}
$sport_menu[]=array("tur_id"=>$turler->tur,
                    "tur"=>$turler->tur_isim,
                    "toplam"=>$turler->toplam,
                    "css_id"=>$turler->css_id,
                    "OddsType"=>$turler->OddsType,
                    "ulkeler"=>$ulkeler_array);
}


//print_r($sport_menu);


return $sport_menu;
}


static function sifrele($value) {
  $key = 'gKyVzVEvHMkEUS45S2hNQkwKcU5mJAqx8QXzDa8KpAbFM5PrfeuqzaZ2hmCJ4p9C4X2PmKcKXTwu7kRwGuWCgQ';
  $iv = mcrypt_create_iv(
   mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC),
   MCRYPT_DEV_URANDOM
  );

  $encrypted = base64_encode(
   $iv .
   mcrypt_encrypt(
    MCRYPT_RIJNDAEL_128,
    hash('sha256', $key, true),
    $value,
    MCRYPT_MODE_CBC,
    $iv
   )
  );
  return str_replace(array('+', '/'), array('-', '_'), $encrypted);
 }
 
 static function sifrecoz($value) { 
  $key = 'gKyVzVEvHMkEUS45S2hNQkwKcU5mJAqx8QXzDa8KpAbFM5PrfeuqzaZ2hmCJ4p9C4X2PmKcKXTwu7kRwGuWCgQ';
  $data = base64_decode(str_replace(array('-', '_'), array('+', '/'), $value));
  $iv = substr($data, 0, mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC));

  $decrypted = rtrim(
   mcrypt_decrypt(
    MCRYPT_RIJNDAEL_128,
    hash('sha256', $key, true),
    substr($data, mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC)),
    MCRYPT_MODE_CBC,
    $iv
   ),
   "\0"
  );
  return $decrypted;
 }
 

static function Orancek($mac_id){
    $adres=    Canli::betradaradres()->betradar_sitesi;
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'vary:Accept-Encoding',
    'x-powered-by:PHP/5.6.12',
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.prematchdetail");
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,'DataSource=1&MatchID='.$mac_id);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);
return $cik;
curl_close ($ch);
}


static function normal_oranlar($mac_id){



$c = self::$db->where(array("MatchID"=>$mac_id,"date(giris)"=>date("Y-m-d")))->select("MatchID")->order_by("bulten_oranlar.Id","ASC")->get('bulten_oranlar')->result();
if(count($c)>0){
self::normal_oranlari_getir($mac_id);  
return json_encode(self::normal_oranlari_getir($mac_id), JSON_PRETTY_PRINT);    
 }else{
$where=array("MatchID"=>$mac_id);    
self::$db->delete("bulten_oranlar",$where);
$o=self::Orancek($mac_id); 
$o=Self::oran_kaydet($o,$mac_id);
return json_encode(self::normal_oranlari_getir($mac_id), JSON_PRETTY_PRINT); 
 }
}

static function normal_oranlari_getir($mac_id){

$kategoriler_array=array();
self::$db->join("bahis_turleri","bahis_turleri.bahis_adi=bulten_oranlar.OddsType and bahis_turleri.mac_turu=bulten_oranlar.SportID");

$kate=self::$db->Where(array("bulten_oranlar.MatchID"=>$mac_id,"bahis_turleri.canli"=>0))->Select("bulten_oranlar.OddsType")->order_by("bahis_turleri.siralama","ASC")->Order_by("bulten_oranlar.Id","ASC")->group_by("bulten_oranlar.OddsType")->get("bulten_oranlar")->result();


foreach ($kate as $kate) {

$oranlarim_array=array();


$orans=self::$db->Where(array("bulten_oranlar.MatchID"=>$mac_id,"bulten_oranlar.OddsType"=>$kate->OddsType))->Select("*")->Get("bulten_oranlar")->result();
//print_r($orans);

foreach ($orans as $orans) {
$oranlarim_array[]=$orans;
}





$kategoriler_array[]=array("kategori"=>$kate->OddsType,
                           "oranlar"=>$oranlarim_array);
}


return $kategoriler_array;

}

static function oran_kaydet($data,$mac_id){

$oranlar=json_decode($data,true);

//print_r($oranlar);

foreach ($oranlar["data"] as $oranlar) {
$mac_id=$oranlar["MatchID"];
$data=array("SportID"=>$oranlar["SportID"],
"Sport"=>$oranlar["Sport"],
"CategoryID"=>$oranlar["CategoryID"],
"Category"=>$oranlar["Category"],
"TournamentID"=>$oranlar["TournamentID"],
"Tournament"=>$oranlar["Tournament"],
"MatchID"=>$oranlar["MatchID"],
"Competitor1"=>$oranlar["Competitor1"],
"Competitor2"=>$oranlar["Competitor2"],
"MatchDate"=>$oranlar["MatchDate"],
"MinimumMatch"=>$oranlar["MinimumMatch"],
"ColumnCount"=>$oranlar["ColumnCount"],
"OddsType"=>$oranlar["OddsType"],
"OddsType1"=>$oranlar["OddsType1"],
"OddsType0"=>$oranlar["OddsType0"],
"OddsType2"=>$oranlar["OddsType2"],
"Odds1ID"=>$oranlar["Odds1ID"],
"Odds0ID"=>$oranlar["Odds0ID"],
"Odds2ID"=>$oranlar["Odds2ID"],
"Odds1"=>self::nokta($oranlar["Odds1"]),
"Odds0"=>self::nokta($oranlar["Odds0"]),
"Odds2"=>self::nokta($oranlar["Odds2"]),
"Odds1Old"=>self::nokta($oranlar["Odds1Old"]),
"Odds0Old"=>self::nokta($oranlar["Odds0Old"]),
"Odds2Old"=>self::nokta($oranlar["Odds2Old"]),
"OddsTypeGroup1"=>$oranlar["OddsTypeGroup1"],
"OddsTypeGroup2"=>$oranlar["OddsTypeGroup2"],
"OddsTypeGroup3"=>$oranlar["OddsTypeGroup3"],
"DataSource"=>$oranlar["DataSource"],
"SelectionCode1"=>$oranlar["SelectionCode1"],
"SelectionCode0"=>$oranlar["SelectionCode0"],
"SelectionCode2"=>$oranlar["SelectionCode2"],);

$sonuc=self::$db->Where(array("bahis_adi"=>$oranlar["OddsType"],"canli"=>0,"mac_turu"=>$oranlar["SportID"]))->select("durum")->get("bahis_turleri")->row();
if(count($sonuc)>0 && $sonuc->durum==1){
self::$db->insert('bulten_oranlar',$data);
}
}

$s = self::$db->where(array("MatchID"=>$mac_id))->select("SportID, Sport, CategoryID, Category, TournamentID, Tournament, MatchID, Competitor1, Competitor2, MatchDate, MinimumMatch, ColumnCount, OddsType, OddsType1, OddsType0, OddsType2, Odds1ID, Odds0ID, Odds2ID, Odds1, Odds0, Odds2, Odds1Old, Odds0Old, Odds2Old, OddsTypeGroup1, OddsTypeGroup2, OddsTypeGroup3, DataSource, SelectionCode1, SelectionCode0, SelectionCode2")->get('bulten_oranlar')->result();
//print_r($s);
return json_encode($s, JSON_PRETTY_PRINT); 

}


static function nokta($t)
{
$tbu = str_replace(",",".",$t);
return $tbu;
}

static function mac_detay($mac_id){

$c = self::$db->where(array("mac_id"=>$mac_id))->select("*")->get('bulten')->row();

 if(count($c)>0){
    
return $c;    
 }else{
return 0;        
 }
        
}

static function kuponmac($mac_id){

$c = self::$db->where(array("mac_id"=>$mac_id,"tarih>"=>date("Y-m-d H:i:s")))->select("*")->get('bulten')->row();

 if(count($c)>0){
    
return $c->mac_id;    
 }else{
return 0;        
 }

}

static function kuponmaccanli($mac_id){

$c = self::$db->where(array("mac_id"=>$mac_id,"canli"=>1,"oynuyormu"=>1))->select("*")->get('bulten')->row();

 if(count($c)>0){
    
return $c->mac_id;    
 }else{
return 0;        
 }

}

static function mac_arama($arama){
$tarih1 = date("Y-m-d 00:00:00");
$yenitarih = strtotime('10 day',strtotime($tarih1));
$yenitarih = date('Y-m-d 00:00:00' ,$yenitarih );

$maclaresult = self::$db->query("SELECT * FROM bulten WHERE  (ev_sahibi LIKE '%$arama%' OR misafir LIKE '%$arama%') AND (tarih > CURDATE() ) GROUP BY mac_id")->result_array();
 
return $maclaresult;
}


static function canli_oran_kontrol($mac_id,$OddsType,$secim,$oran,$degisiklik_kabulmu){

$sonuc=0;

$oranlar=json_decode(Canli::CanliOranlar($mac_id),true);
//print_r($oranlar["data_header"]);
$oran_baslik=$oranlar["data_header"];


foreach ($oranlar["data"] as $oranlar) {


$veri_oran_turu=$oranlar["OddsType"];

$veri_oran_turu=str_replace($oran_baslik["Competitor1"],"Ev Sahibi",$veri_oran_turu);
$veri_oran_turu=str_replace($oran_baslik["Competitor2"],"Misafir",$veri_oran_turu);
$veri_oran_turu=str_replace(",","",$veri_oran_turu);

//echo $veri_oran_turu." - ".$OddsType."<br><br>";
if($OddsType==$veri_oran_turu){


$odds1tipi=str_replace($oranlar["Competitor1"],"Ev Sahibi",$oranlar["OddsType1"]);
$odds1tipi=str_replace($oranlar["Competitor2"],"Misafir",$odds1tipi);
$odds1tipi=str_replace(',',"",$odds1tipi);


$odds0tipi=str_replace($oranlar["Competitor1"],"Ev Sahibi",$oranlar["OddsType0"]);
$odds0tipi=str_replace($oranlar["Competitor2"],"Misafir",$odds0tipi);
$odds0tipi=str_replace(",","",$odds0tipi);


$odds2tipi=str_replace($oranlar["Competitor1"],"Ev Sahibi",$oranlar["OddsType2"]);
$odds2tipi=str_replace($oranlar["Competitor2"],"Misafir",$odds2tipi);
$odds2tipi=str_replace(",","",$odds2tipi);


if($secim==$odds1tipi && $oranlar["BetStatus"]=="started" && $oranlar["NoOdd1"]!=1){
$sonuc=self::nokta($oranlar["Odds1"]);
}

if($secim==$odds0tipi && $oranlar["BetStatus"]=="started" && $oranlar["NoOdd0"]!=1){
$sonuc=self::nokta($oranlar["Odds0"]);

}


if($secim==$odds2tipi && $oranlar["BetStatus"]=="started" && $oranlar["NoOdd2"]!=1){
$sonuc=self::nokta($oranlar["Odds2"]);

}

}

}


if($degisiklik_kabulmu=="false"){
if($sonuc>0 && $sonuc==self::nokta($oran)){
$sonuc=$oran;  
}else{
$sonuc=0;  
}
}



return $sonuc;
}


    // Get logged in user ID
    static function icerik_sayfa($seo)
    {
        $ci = &get_instance();
       return self::$db->Where(array("seo"=>$seo))->Select("*")->get('sayfalar')->row();
    }


    static function promosyonlar()
    {
        $ci = &get_instance();
       return self::$db->Select("*")->get('promosyonlar')->result();
    }

    static function promosyondetay($id)
    {
        $ci = &get_instance();
       return self::$db->where(array("Id"=>$id))->Select("*")->get('promosyonlar')->row();
    }
}

/* End of file model.php */
