<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Canli extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }

    // Get logged in user ID
  
static function betradaradres(){
return self::$db->Select("betradar_sitesi")->get('ayarlar')->row();    
}

static function toplam_canli(){

return self::$db->Where(array("canli"=>1,"oynuyormu"=>1,"aktif"=>1))->Select("count(Id) As toplam")->get('bulten')->row();    

}

static function turlere_gore_toplam(){

return self::$db->Where(array("canli"=>1,"oynuyormu"=>1))->Select("count(Id) As toplam,tur, tur_isim")->group_by("tur")->get('bulten')->result();    

}

static function bahisacikmi($sporttype,$bahis_adi){

//echo $bahis_adi."<br>";
$sonuc=self::$db->Where(array("mac_turu"=>$sporttype,"bahis_adi"=>$bahis_adi,"canli"=>1))->Select("durum")->get('bahis_turleri')->row();
//print_r($sonuc);

 if(count($sonuc)>0){
return $sonuc->durum;    
 }else{
return 0;    
}    




}
static function listlivematch(){


$sorgu_tur["bulten.bittimi"]=0;


$sorgu_tur["bulten.aktif"]=1;
$sorgu_tur["bulten.canli"]=1;
$sorgu_tur["bulten.oynuyormu"]=1;


self::$db->join('mac_turleri','mac_turleri.tur_id = bulten.tur');
$turler=self::$db->Where($sorgu_tur)->Select("bulten.tur,bulten.tur_isim, count(bulten.Id) AS toplam,mac_turleri.css_id,bulten.OddsType")->Group_by("tur")->get('bulten')->result();


$sport_menu=array();


foreach ($turler as $turler) {

$ulkeler_array=array();

$sorgu_ulke["bulten.bittimi"]=0;



$sorgu_ulke["bulten.aktif"]=1;
$sorgu_ulke["bulten.canli"]=1;
$sorgu_ulke["bulten.oynuyormu"]=1;
$sorgu_ulke["bulten.tur"]=$turler->tur;
$sorgu_ulke["ulkeler.sporttype"]=$turler->tur;


self::$db->join('ulkeler','ulkeler.country_id = bulten.ulke_id');
$ulkeler=self::$db->Where($sorgu_ulke)->Select("bulten.ulke_id,bulten.ulke, count(bulten.Id) AS toplam,ulkeler.css_id")->Group_by("bulten.ulke_id")->order_by("ulkeler.siralama","ASC")->order_by("ulkeler.country_id","ASC")->get('bulten')->result();

foreach ($ulkeler as $ulkeler) {


    $maclar_array=array();



$sorgu_maclar["bulten.bittimi"]=0;
$sorgu_maclar["bulten.aktif"]=1;
$sorgu_maclar["bulten.oynuyormu"]=1;
$sorgu_maclar["bulten.canli"]=1;
$sorgu_maclar["bulten.tur"]=$turler->tur;
$sorgu_maclar["bulten.ulke_id"]=$ulkeler->ulke_id;




$maclar=self::$db->Where($sorgu_maclar)->Select("Id, tur, tur_isim, ulke_id, ulke, lig_id, lig, mac_id, ev_sahibi,Odds1,Odds0,Odds2,Odds1ID,Odds0ID,Odds2ID, misafir, tarih, durum_str, ms, dakika")->get('bulten')->result();    



//print_r($maclar);
 foreach ($maclar as $maclar) {
     
     $oran_1_sifre="1|".$maclar->tur."|".$maclar->mac_id."|".$maclar->Odds1ID."|".'Ev Sahibi'."|".'Ev Sahibi'."|".$maclar->Odds1."|".$maclar->dakika."|".str_replace(":","-",$oranlar["MatchScore"])."|".''."|".$maclar->ev_sahibi."|".$maclar->misafir;

     $oran_0_sifre="1|".$maclar->tur."|".$maclar->mac_id."|".$maclar->Odds0ID."|".''."|".''."|".$maclar->Odds0."|".$maclar->dakika."|".str_replace(":","-",$maclar->ms)."|".''."|".$maclar->ev_sahibi."|".$maclar->misafir;

     $oran_2_sifre="1|".$maclar->tur."|".$maclar->mac_id."|".$maclar->Odds1ID."|".'Misafir'."|".'Misafir'."|".$maclar->Odds2."|".$maclar->dakika."|".str_replace(":","-",$maclar->ms)."|".''."|".$maclar->ev_sahibi."|".$maclar->misafir;

$maclar_array[]=array("Id"=>$maclar->Id,
                    "tur"=>$maclar->tur,
                    "tur_isim"=>$maclar->tur_isim,
                    "ulke_id"=>$maclar->ulke_id,
                    "ulke"=>$maclar->ulke,
                    "lig_id"=>$maclar->lig_id,
                    "lig"=>$maclar->lig,
                    "mac_id"=>$maclar->mac_id,
                    "ev_sahibi"=>$maclar->ev_sahibi,
                    "misafir"=>$maclar->misafir,
                    "tarih"=>$maclar->tarih,
                    "durum"=>$maclar->durum_str,
                    "ms"=>$maclar->ms,
                    "Odds1"=>$maclar->Odds1,
                    "Odds0"=>$maclar->Odds0,
                    "Odds2"=>$maclar->Odds2,
                    "Odds1ID"=>$maclar->Odds1ID,
                    "Odds0ID"=>$maclar->Odds0ID,
                    "Odds2ID"=>$maclar->Odds2ID,
                    "oran_1_sifre"=>Genel::sifrele($oran_1_sifre),
                    "oran_0_sifre"=>Genel::sifrele($oran_0_sifre),
                    "oran_2_sifre"=>Genel::sifrele($oran_2_sifre),
                    "dakika"=>$maclar->dakika,);


 }

$ulkeler_array[]=array("ulke_id"=>$ulkeler->ulke_id,
                       "ulke"=>$ulkeler->ulke,
                       "css_id"=>$ulkeler->css_id,
                       "toplam"=>$ulkeler->toplam,
                       "maclar"=>$maclar_array);





}
$sport_menu[]=array("tur_id"=>$turler->tur,
                    "tur"=>$turler->tur_isim,
                    "toplam"=>$turler->toplam,
                    "css_id"=>$turler->css_id,
                    "OddsType"=>$turler->OddsType,
                    "ulkeler"=>$ulkeler_array);
}


//print_r($sport_menu);

//print_r($sport_menu);
return $sport_menu;



}
static function canlilist(){
    $adres=    self::betradaradres()->betradar_sitesi;
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'vary:Accept-Encoding',
    'x-powered-by:PHP/5.6.12',
    'device:d'
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.livematch");
curl_setopt($ch, CURLOPT_REFERER,$adres."live");
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
//curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//curl_setopt($ch, CURLOPT_POSTFIELDS,'hour=86400&search=null&category='.$ulke.'&tournament=all');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);


return $cik;
curl_close ($ch);
}


static function CanliOranlar($mac)
{


        $adres=    self::betradaradres()->betradar_sitesi;
$conc = strlen("MatchID=$mac&DataSource=1");
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'content-length:'.$conc,
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.livematchdetail");
curl_setopt($ch, CURLOPT_REFERER,$adres."live");
curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,'MatchID='.$mac.'&DataSource=1');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);
return $cik;
curl_close ($ch);

}

}

/* End of file model.php */
