<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Coupons extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }


    static function ozet_toplam_kupon($kullanici = NULL , $durum = NULL , $tarih1, $tarih2)
    {

        $ci = &get_instance();
$where["date(kupon.tarih)>="]=date("Y-m-d",strtotime($tarih1));
$where["date(kupon.tarih)<="]=date("Y-m-d",strtotime($tarih2));

/*if($kullanici!=NULL && strlen($kullanici)){
$where["user_id"]=$kullanici;
}*/

if($durum!=NULL && strlen($durum)){
  if($durum==-1){
$where["kupon.durum"]=0;
  }else{
$where["kupon.durum"]=$durum;
}
}
		$aff=User::view_user($_SESSION['user_id']);
		$kid=$aff->affkodu;
$where["users.affkimdir"]=$kid;
//print_r($kid);
self::$db->join("users","users.id=kupon.user_id");
return self::$db->where($where)->Select("Count(kupon.Id) AS toplam, SUM(kupon.miktar) AS yatan, SUM(kupon.oran*kupon.miktar) AS olasi_kazanc")->get('kupon')->row();
   }

   static function kupon_listesi($kullanici = NULL , $durum = NULL , $tarih1, $tarih2,$limit = NULL,$start = NULL)
    {
    $ci = &get_instance();
$where["date(kupon.tarih)>="]=date("Y-m-d",strtotime($tarih1));
$where["date(kupon.tarih)<="]=date("Y-m-d",strtotime($tarih2));

if($kullanici!=NULL && strlen($kullanici)){
$where["users.affkimdir"]=$kullanici;
}

if($durum!=NULL && strlen($durum)){
$where["kupon.durum"]=$durum;
}

self::$db->join("users","users.id=kupon.user_id");
self::$db->join("kupon_mac","kupon_mac.kupon_id=kupon.ID and kupon_mac.durum>0","left");
return self::$db->where($where)->group_by("kupon.Id")->order_by("Id","DESC")->Select("kupon.*,users.username, count(kupon_mac.Id) AS biten")->get('kupon',$limit,$start)->result();
   }


static function kupon_detay($kupon_id){
self::$db->join("users","users.id=kupon.user_id");
self::$db->join("kupon_mac","kupon_mac.kupon_id=kupon.ID and kupon_mac.durum>0","left");
return self::$db->where(array("kupon.id"=>$kupon_id))->group_by("kupon.Id")->order_by("Id","DESC")->Select("kupon.*,users.username, count(kupon_mac.Id) AS biten")->get('kupon')->row();
}

static function kupon_maclar($kupon_id){
return self::$db->where(array("kupon_mac.kupon_id"=>$kupon_id))->Select("*")->get('kupon_mac')->result();
}

static function mac_durum($durum_id){
return self::$db->where(array("durum_id"=>$durum_id))->Select("durum")->get('mac_durumlari')->row();	
}




}

/* End of file model.php */
